EXP_FOLDER="gs://gen-tfrc-uscentral1/tfrc_out/imagenet2012/conv_sngan_21-09-29-20-28-32"

# checkpoint info
MIN_EPOCH="150000"
MAX_EPOCH="160000"
EPOCH_FREQ="5000"

# energy model paramters
TEMPS=("1e-5")
JOINT_TEMPS=("1.01")
TAUS=("1.5e-1")
MCMC_STEPS=("1000000")

# fixed generator for longrun models
CHANGE_GEN=false
GEN_PATH="gs://gen-tfrc-europewest4/biggan-128-deep_tf2/weights"

# config file to use with exp
CONFIG_FILE="configs_fid/fid_longrun_imagenet.py"


# time stamp and base strings for net checkpoints
TIMESTAMP=$(date +%s)

BASE_EBM_PATH="${EXP_FOLDER}/checkpoints/ebm_"
BASE_GEN_PATH="${EXP_FOLDER}/checkpoints/gen_"

# fid calc looped over checkpoints and model parameters
for i in $(seq ${MIN_EPOCH} ${EPOCH_FREQ} ${MAX_EPOCH})
do
for temp in "${TEMPS[@]}"
do
for joint_temp in "${JOINT_TEMPS[@]}"
do
for tau in "${TAUS[@]}"
do
for mcmc_step in "${MCMC_STEPS[@]}"
do
  EBM_PATH="${BASE_EBM_PATH}$i.ckpt"
  if [[ $CHANGE_GEN = true ]]
  then
    GEN_PATH="${BASE_GEN_PATH}$i.ckpt"
  fi
  python3 ebm-life-cycle/fid.py ${CONFIG_FILE} --ebm_path ${EBM_PATH} --gen_path ${GEN_PATH} --temp ${temp} --joint_temp ${joint_temp} --tau ${tau} --mcmc_steps ${mcmc_step} --time_stamp ${TIMESTAMP} --save_str "_${i}_${temp}_${joint_temp}_${tau}_${mcmc_step}"
done
done
done
done
done
